<?php session_start(); require_once 'config.php'; ?>
<!doctype html>
<html class="no-js" lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Service Details - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        :root {
            --theme-color: #109C3D;
            --secondary-color: #042A2F;
            --title-color: #063A41;
            --text-color: #5E5C78;
            --light-color: #f1f5f4;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #f1f5f4 0%, #ffffff 100%);
            min-height: 100vh;
        }

        /* ===== SERVICE DETAILS WRAPPER ===== */
        .service-details-wrapper {
            padding: clamp(20px, 5vw, 40px) 0;
        }

        /* ===== FEATURED IMAGE ===== */
        .service-featured-image-wrapper {
            position: relative;
            margin-bottom: clamp(30px, 4vw, 50px);
            border-radius: 16px;
            overflow: hidden;
            background: white;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }

        .service-featured-image {
            width: 100%;
            max-height: 500px;
            object-fit: cover;
            display: block;
            transition: transform 0.5s ease;
        }

        .service-featured-image-wrapper:hover .service-featured-image {
            transform: scale(1.03);
        }

        .badge {
            position: absolute;
            top: 20px;
            right: 20px;
            background: linear-gradient(135deg, #109C3D 0%, #067839 100%);
            color: white;
            padding: 10px 20px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 13px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 20px rgba(16, 156, 61, 0.3);
        }

        /* ===== HEADER WITH GLASSMORPHISM ===== */
        .service-post-header {
            margin-bottom: clamp(30px, 4vw, 50px);
            padding: clamp(20px, 3vw, 40px);
            background: rgba(255, 255, 255, 0.7);
            border-radius: 16px;
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.8);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }

        .service-post-header:hover {
            background: rgba(255, 255, 255, 0.9);
            box-shadow: 0 12px 48px rgba(0, 0, 0, 0.12);
        }

        .service-post-header h2 {
            font-size: clamp(28px, 4vw, 48px);
            font-weight: 800;
            margin-bottom: clamp(15px, 2vw, 25px);
            color: #063A41;
            line-height: 1.2;
            background: linear-gradient(135deg, #063A41 0%, #109C3D 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* ===== SERVICE CONTENT ===== */
        .service-post-content {
            font-size: clamp(15px, 2vw, 17px);
            line-height: 1.8;
            color: #555;
            background: rgba(255, 255, 255, 0.6);
            border-radius: 16px;
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.7);
            padding: clamp(25px, 3vw, 40px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.05);
            margin-bottom: clamp(25px, 3vw, 40px);
        }

        .service-post-content h3 {
            font-size: clamp(20px, 3.5vw, 32px);
            font-weight: 700;
            color: #063A41;
            margin: clamp(30px, 4vw, 50px) 0 clamp(15px, 2vw, 25px);
            position: relative;
            padding-left: 20px;
        }

        .service-post-content h3:before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: clamp(20px, 3vw, 30px);
            background: linear-gradient(135deg, #109C3D 0%, #067839 100%);
            border-radius: 4px;
        }

        .service-post-content p {
            margin-bottom: clamp(15px, 2vw, 25px);
            text-align: justify;
        }

        .service-post-content ul {
            margin-left: clamp(20px, 3vw, 30px);
            margin-bottom: clamp(15px, 2vw, 25px);
            list-style: none;
            padding: 0;
        }

        .service-post-content li {
            margin-bottom: clamp(12px, 1.5vw, 16px);
            padding-left: clamp(30px, 3vw, 40px);
            position: relative;
        }

        .service-post-content li:before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #109C3D;
            font-weight: bold;
            font-size: clamp(18px, 2vw, 22px);
        }

        /* ===== SERVICE INFO SIDEBAR WITH GLASSMORPHISM ===== */
        .service-info-sidebar {
            background: linear-gradient(135deg, rgba(16, 156, 61, 0.15) 0%, rgba(4, 42, 47, 0.1) 100%);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(16, 156, 61, 0.2);
            padding: clamp(25px, 3vw, 40px);
            border-radius: 16px;
            color: #063A41;
            position: sticky;
            top: clamp(80px, 10vw, 120px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }

        .service-info-sidebar:hover {
            background: linear-gradient(135deg, rgba(16, 156, 61, 0.2) 0%, rgba(4, 42, 47, 0.15) 100%);
            box-shadow: 0 12px 48px rgba(0, 0, 0, 0.12);
            transform: translateY(-4px);
        }

        .info-box {
            margin-bottom: clamp(25px, 3vw, 35px);
            padding: clamp(15px, 2vw, 20px);
            background: rgba(255, 255, 255, 0.6);
            border-radius: 12px;
            border: 1px solid rgba(255, 255, 255, 0.7);
            border-left: 4px solid #109C3D;
            transition: all 0.3s ease;
        }

        .info-box:hover {
            background: rgba(255, 255, 255, 0.8);
            transform: translateX(8px);
        }

        .info-box h4 {
            font-size: clamp(13px, 1.8vw, 14px);
            font-weight: 700;
            margin-bottom: clamp(8px, 1vw, 10px);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #109C3D;
        }

        .info-box p {
            font-size: clamp(16px, 2.5vw, 20px);
            font-weight: 700;
            margin: 0;
            color: #063A41;
        }

        .service-info-sidebar .vs-btn {
            width: 100%;
            background: linear-gradient(135deg, #109C3D 0%, #067839 100%);
            color: white;
            font-weight: 700;
            border: none;
            padding: clamp(14px, 2vw, 18px) clamp(20px, 3vw, 30px);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            cursor: pointer;
            border-radius: 8px;
            box-shadow: 0 8px 20px rgba(16, 156, 61, 0.3);
            font-size: clamp(13px, 2vw, 15px);
        }

        .service-info-sidebar .vs-btn:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 32px rgba(16, 156, 61, 0.4);
        }

        /* ===== BENEFITS SECTION ===== */
        .benefits-section {
            background: rgba(255, 255, 255, 0.7);
            border-radius: 16px;
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.8);
            padding: clamp(25px, 3vw, 40px);
            margin-bottom: clamp(30px, 4vw, 50px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.05);
        }

        .benefits-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: clamp(15px, 2.5vw, 25px);
            margin-top: clamp(20px, 3vw, 30px);
        }

        .benefit-item {
            text-align: center;
            padding: clamp(15px, 2vw, 20px);
            background: linear-gradient(135deg, rgba(16, 156, 61, 0.1) 0%, rgba(4, 42, 47, 0.05) 100%);
            border-radius: 12px;
            border: 1px solid rgba(16, 156, 61, 0.2);
            transition: all 0.3s ease;
        }

        .benefit-item:hover {
            background: linear-gradient(135deg, rgba(16, 156, 61, 0.15) 0%, rgba(4, 42, 47, 0.1) 100%);
            transform: translateY(-8px);
        }

        .benefit-icon {
            font-size: clamp(28px, 4vw, 36px);
            color: #109C3D;
            margin-bottom: 10px;
        }

        .benefit-title {
            font-size: clamp(14px, 2.2vw, 16px);
            font-weight: 700;
            color: #063A41;
        }

        /* ===== RELATED SERVICES ===== */
        .related-services {
            margin-top: clamp(40px, 5vw, 80px);
            padding-top: clamp(40px, 5vw, 80px);
            border-top: 2px solid rgba(16, 156, 61, 0.2);
        }

        .related-services h3 {
            font-size: clamp(20px, 3vw, 28px);
            font-weight: 700;
            color: #063A41;
            margin-bottom: clamp(20px, 3vw, 30px);
        }

        .related-services-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: clamp(20px, 3vw, 30px);
        }

        .related-service-card {
            background: rgba(255, 255, 255, 0.7);
            border-radius: 14px;
            overflow: hidden;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.8);
            transition: all 0.3s ease;
            text-decoration: none;
            color: inherit;
            display: flex;
            flex-direction: column;
        }

        .related-service-card:hover {
            transform: translateY(-12px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .related-service-card img {
            width: 100%;
            height: 220px;
            object-fit: cover;
        }

        .related-service-card-content {
            padding: clamp(15px, 2vw, 25px);
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .related-service-card-content h4 {
            font-size: clamp(15px, 2.2vw, 18px);
            font-weight: 700;
            color: #063A41;
            margin: 0 0 clamp(8px, 1vw, 12px);
            line-height: 1.3;
        }

        .related-service-card-content p {
            font-size: clamp(12px, 1.8vw, 14px);
            color: #666;
            margin: 0;
        }

        .loading-state {
            text-align: center;
            padding: clamp(40px, 5vw, 80px) 20px;
            font-size: clamp(16px, 2vw, 20px);
            color: #666;
        }

        .loading-spinner {
            display: inline-block;
            margin-right: 10px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* ===== RESPONSIVE DESIGN ===== */
        @media (max-width: 992px) {
            .service-info-sidebar {
                position: static;
                margin-top: clamp(30px, 4vw, 40px);
            }
        }

        @media (max-width: 768px) {
            .service-details-wrapper {
                padding: 20px;
            }

            .service-featured-image {
                max-height: 350px;
            }

            .related-services-grid {
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            }

            .benefits-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 576px) {
            .service-featured-image {
                max-height: 250px;
                border-radius: 12px;
            }

            .service-post-header,
            .service-post-content,
            .benefits-section {
                padding: clamp(15px, 2vw, 20px);
                border-radius: 12px;
            }

            .service-post-header h2 {
                font-size: 24px;
            }

            .badge {
                top: 15px;
                right: 15px;
                padding: 8px 16px;
                font-size: 11px;
            }

            .related-services-grid {
                grid-template-columns: 1fr;
            }

            .benefits-grid {
                grid-template-columns: 1fr;
            }

            .service-info-sidebar {
                margin-top: 20px;
            }
        }
    </style>
</head>
<body>
    <!-- <div class="preloader">
        <button class="vs-btn preloaderCls">Cancel Preloader</button>
        <div class="preloader-inner">
            <img src="assets/img/logo.svg" alt="logo">
            <span class="loader"></span>
        </div>
    </div> -->

    <?php include 'header.php'; ?>

    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
            <div class="container z-index-common">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">Service Details</h1>
                </div>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="service.php">Service </a></li>
                        <li>our service</li>
                    </ul>
                </div>
            </div>
        </div>

    <section class="service-details space">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div id="serviceDetailsContainer" class="loading-state">
                        <i class="fas fa-spinner fa-spin loading-spinner"></i> Loading service details...
                    </div>
                </div>
                <div class="col-lg-4">
                    <div id="serviceInfoContainer" class="service-info-sidebar">
                        <i class="fas fa-spinner fa-spin loading-spinner"></i> Loading...
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'footer.php'; ?>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>

    <script>
        function getServiceIdFromURL() {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get('id');
        }

        function loadServiceDetails() {
            const serviceId = getServiceIdFromURL();
            
            if (!serviceId) {
                document.getElementById('serviceDetailsContainer').innerHTML = '<p style="color: red;">Invalid service ID</p>';
                return;
            }

            fetch(`api_handler.php?action=get_service_details&id=${serviceId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data) {
                        renderServiceDetails(data.data);
                        loadRelatedServices(data.data.category);
                    } else {
                        document.getElementById('serviceDetailsContainer').innerHTML = '<p style="color: red;">Service not found</p>';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('serviceDetailsContainer').innerHTML = '<p style="color: red;">Error loading service</p>';
                });
        }

        function renderServiceDetails(service) {
            const imageUrl = service.image || 'assets/img/service/service-img-1-1.jpg';

            let html = `
                <div class="service-details-wrapper">
                    <div class="service-featured-image-wrapper">
                        <img class="service-featured-image" src="${imageUrl}" alt="${service.name}" style="width: 100%; height: 100%; object-fit: cover;">
                        <div class="badge">⭐ Featured Service</div>
                    </div>
                    <div class="service-post-header">
                        <h2>${service.name}</h2>
                    </div>
                    <div class="service-post-content">
                        <p>${service.description || 'Professional service for your cleaning needs.'}</p>
                        <h3>What's Included</h3>
                        <ul>
                            <li>Professional trained cleaning team</li>
                            <li>Eco-friendly and safe cleaning products</li>
                            <li>Flexible scheduling options</li>
                            <li>Quality assurance guarantee</li>
                            <li>Custom cleaning solutions</li>
                            <li>Insurance and bonded staff</li>
                        </ul>
                        <h3>Why Choose Our Service?</h3>
                        <p>Experience premium cleaning services that go beyond your expectations. Our dedicated professionals use modern techniques and sustainable products to ensure your spaces are not just clean, but also safe for your family and pets.</p>
                    </div>
                    
                    <div class="benefits-section">
                        <h3 style="margin-top: 0; padding-left: 0;">Benefits & Features</h3>
                        <div class="benefits-grid">
                            <div class="benefit-item">
                                <div class="benefit-icon">⚡</div>
                                <div class="benefit-title">Quick Service</div>
                            </div>
                            <div class="benefit-item">
                                <div class="benefit-icon">🔒</div>
                                <div class="benefit-title">100% Safe</div>
                            </div>
                            <div class="benefit-item">
                                <div class="benefit-icon">💚</div>
                                <div class="benefit-title">Eco-Friendly</div>
                            </div>
                            <div class="benefit-item">
                                <div class="benefit-icon">✅</div>
                                <div class="benefit-title">Quality Assured</div>
                            </div>
                        </div>
                    </div>
                </div>
            `;

            document.getElementById('serviceDetailsContainer').innerHTML = html;
            renderServiceInfo(service);
        }

        function renderServiceInfo(service) {
            let html = `
                <div class="info-box">
                    <h4>📌 Service</h4>
                    <p>${service.name}</p>
                </div>
                <div class="info-box">
                    <h4>🏷️ Category</h4>
                    <p>${service.category || 'General Cleaning'}</p>
                </div>
                <div class="info-box">
                    <h4>⏱️ Duration</h4>
                    <p>1-4 Hours</p>
                </div>
                <div class="info-box">
                    <h4>📅 Frequency</h4>
                    <p>Weekly/Monthly</p>
                </div>
                <div class="info-box">
                    <h4>👥 Team Size</h4>
                    <p>2-4 Professionals</p>
                </div>
                <a href="contact.php" class="vs-btn">📞 Book Now</a>
            `;

            document.getElementById('serviceInfoContainer').innerHTML = html;
        }

        function loadRelatedServices(category) {
            fetch('api_handler.php?action=get_services')
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data) {
                        const related = data.data.filter(s => s.category === category).slice(0, 3);
                        if (related.length > 0) {
                            renderRelatedServices(related);
                        }
                    }
                })
                .catch(error => console.error('Error:', error));
        }

        function renderRelatedServices(services) {
            let html = `
                <div class="related-services">
                    <h3>Related Services</h3>
                    <div class="related-services-grid">
            `;

            services.forEach(service => {
                const imageUrl = service.image || 'assets/img/service/service-img-1-1.jpg';
                html += `
                    <a href="service-details.php?id=${service.id}" class="related-service-card">
                        <img src="${imageUrl}" alt="${service.name}">
                        <div class="related-service-card-content">
                            <h4>${service.name}</h4>
                        </div>
                    </a>
                `;
            });

            html += `
                    </div>
                </div>
            `;

            const container = document.getElementById('serviceDetailsContainer');
            container.innerHTML += html;
        }

        document.addEventListener('DOMContentLoaded', function() {
            loadServiceDetails();
        });
    </script>
</body>
</html>
